yaml_cqg = """
$k$ is the number of questions you can ask the Student. Format the questions in the following YAML format. Add each question right after the colon without a newline:
---
question_1: <generate question_1 which addresses the "target_understanding">
question_2: <generate question_2 which addresses the "target_understanding">
...
question_k: <generate question_k which addresses the "target_understanding">
---
"""

yaml_student_answer = """
Answer the above "question" only. 

Format your answer as "student_answer" in the following YAML format. Add your "student_answer" right after the colon without a newline. Do not generate or output any code in your answer, please - keep your answer in English only:
---
student_answer: <student answer to instructor "question">
---
"""

i2i_cqg_code = lambda k, bug_fixes, bug_description: f"""
Based on the buggy code, what is {k} follow-up question that you could ask based on the Student's bugs (after tag 'bug_description') that would help them understand their bug? 
These questions should help the Student arrive at the answer themselves; do NOT give any direct hints towards the solution (under tag "bug_fixes" and tag "bug_description").
{bug_fixes}
{bug_description}
---
Your generated question list:
"""


i2i_qg = lambda k, convo_history, bug_fixes, bug_description: f"""
Based on the student's current level of understanding, as demonstrated through their conversation history (tag "conversation_history"), what is {k} follow-up question that you could ask based on the Student's response to your most recent question and your overall conversation with them (after tag "conversation_history") that would help them understand their bug? 

These questions should help the Student arrive at the answer themselves; do NOT give any direct hints towards the solution (under tag "bug_fixes" and tag "bug_description").
{bug_fixes}
{bug_description}

---
conversation_history:
{convo_history}
---

"""

stud_end2end_code_gen = lambda student_responses, buggy_code: f"""
Your responses were as follows - 
{student_responses}

Now give me the corrected code based on your responses on the above 
{buggy_code}

Only output the corrected final python code:
"""


i2s_generate_bug_fixes = lambda convo_history: f"""Are any bug fixes mentioned in the conversation that you have had with the Instructor (under tag "conversation_history")? If no, return "None". If yes, then follow the format below:

First, based on your current understanding of the problem (tag "problem") and your conversation with the Instructor, summarize (after tag "bug_summarization") the bugs in the code explicitly mentioned within the "conversation_history" that you believe will revise your buggy code (after tag "buggy code") to a correct implementation of the "problem" statement. Then, based on this summary, output a list of the explicitly mentioned bug fixes (from "bug_fix_1" to "bug_fix_n", where $n$ is the number of bug fixes to make), each described briefly. 

An example format/wording of a brief bug fix would be: "Replace `i` with `i+1` on line 6."

---
conversation_history:
{convo_history}
---

Follow the following YAML format for your outputted bug summary and bug fixes:
---
bug_summarization: <summarize the bugs explicitly mentioned in the "conversation_history" in 1-2 sentences>
bug_fix_1: <bug_fix_1 here>
bug_fix_2: <bug_fix_2 here>
...
bug_fix_n: <bug_fix_n here>
---
"""

def v2v_check_isomorphic_eq_bf(student_bf, correct_bf, k):
    instruction = f"""
For the problem description given above (after tag 'problem'), you are given two sets of bug fixes (under tags 'suggested_bug_fixes' and 'correct_bug_fixes'). For each bug fix in 'correct_bug_fixes', is there at least one bug fix in 'suggested_bug_fixes' that is isomorphic? Two bug fixes are isomorphic if they (1) have the same conclusion or output, (2) share the same underlying logical structure or pattern, and (3) are convertible to each other through a series of logical transformations. Output "True" or "False" as your answer with an explanation.

suggested_bug_fixes: 
{student_bf}

correct_bug_fixes: 
{correct_bf}

Format your answer for each of the {k} "correct_bug_fixes" and provide an explanation for it in the following YAML format:
---
"""
    prefix = ["correct_bug_fix", "explanation_bug_fix"]
    for i in range(1, k+1):
        instruction += f"\n{prefix[0]}_{i}_present: <output 'True' if 'correct_bug_fix_{i}' is isomorphic to any bug fix in 'suggested_bug_fixes'; output 'False' if not>\n"
        instruction += f"\n{prefix[1]}_{i}_present: <output a one sentence justification behind your answer for 'correct_bug_fix_{i}_present'>\n"
    
    instruction += "---\n"

    return instruction